﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;
using System.Timers;


/* Timer classes and Control.Invoke() method  */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent(); 

            StartTimers();
        }

        System.Threading.Timer timer1;
        System.Timers.Timer timer2;
        System.Windows.Forms.Timer timer3;

        bool executing = false;

        void StartTimers()
        {
            if (!executing)
            {
                timer1 = new System.Threading.Timer(Threading_TimerTick, "System.Threading", 3000, 3000);

                timer2 = new System.Timers.Timer(2500);
                timer2.Elapsed += new ElapsedEventHandler(Timers_TimerTick);
                timer2.Start();

                timer3 = new System.Windows.Forms.Timer();
                timer3.Interval = 2000;
                timer3.Tick += new EventHandler(WindowsForms_TimerTick); 
                timer3.Start();

                executing = true;
            }
        }

        void StopTimers()
        {
            if (executing)
            {
                timer1.Dispose();
                timer2.Stop();
                timer2.Close();
                timer3.Stop();

                executing = false;
            }
        }

        void Threading_TimerTick(object state)
        {
            DisplayTimerMessage(state.ToString());
        }

        void Timers_TimerTick(object sender, ElapsedEventArgs e)
        {
            DisplayTimerMessage("System.Timers");
        }

        void WindowsForms_TimerTick(object sender, EventArgs e)
        {
            DisplayTimerMessage("System.Windows.Forms");
        }

        delegate void MessageDelegate(string msg);

        void DisplayTimerMessage(string msg)
        {
            if (textBox1.InvokeRequired)
                textBox1.Invoke(new MessageDelegate(DisplayTimerMessage), msg + " [invoked]");
            else
                textBox1.Text += msg + Environment.NewLine;
        } 
 
        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = executing;

            if (e.Cancel)
                MessageBox.Show("Please stop timers manually! Timers are still executed...");
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            StartTimers();
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            StopTimers();
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            textBox1.Text = "";
        }
 
    }
}
 